/*
 * @(#)ClassEvent.java  1.0  30. Januar 2004
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */


package ch.hslu.cm.oo.objectmodel;

import java.util.*;
/**
 * An event created by {@link OMObject} objects.
 * 
 * @author Werner Randelshofer
 * @version 1.0 30. Januar 2004  Created.
 */
public class OMObjectEvent extends EventObject {
    private OMLink link;
    private Object message;
    private boolean visualizeInternalProcessing;
    private boolean isException;
    
    /**
     * Creates a new instance of ObjectEvent.
     * Use this constructor for constructorExited, objectDisposed and stateChanged events.
     */
    public OMObjectEvent(OMObject src) {
        super(src);
    }
    /**
     * Creates a new instance of ObjectEvent.
     * Use this constructor for linkAdded and linkRemoved events.
     */
    public OMObjectEvent(OMObject src, OMLink link) {
        super(src);
        this.link = link;
    }
    /**
     * Creates a new instance of ObjectEvent.
     * Use this constructor for methodEntered, methodExited, constructorEntered
     * events.
     */
    public OMObjectEvent(OMObject src, OMLink link, Object message, boolean visualizeInternalProcessing, boolean isException) {
        super(src);
        this.link = link;
        this.message = message;
        this.visualizeInternalProcessing = visualizeInternalProcessing;
        this.isException = isException;
    }
 
    public OMObject getSimulatedObject() {
        return (OMObject) getSource();
    }
    /**
     * Returns the link.
     */
    public OMLink getSimulatedLink() {
        return link;
    }
    /**
     * Returns the message or constructor name.
     */
    public String getMessage() {
        return ""+message;
    }
    /**
     * Returns the response.
     */
    public Object getResponse() {
        return message;
    }
    /**
     * Returns true if the internal processing of a method should be visualized.
     */
    public boolean isVisualizeInternalProcessing() {
        return visualizeInternalProcessing;
    }
    /**
     * Returns true if the message is an exception.
     */
    public boolean isException() {
        return isException;
    }
}
